<?php
/**
*Plugin Name: TSL plugin sitemap xml
*Plugin URI:  http://wpavonis.ru/tsl-plaginy/plagin-sozdanija-sitemap-xml-v-korne-sajta.html
*Author URI:  http://wpavonis.ru/tsl-plaginy.html
*Description: Generated sitemap.xml for publish post and page
*Author:      GoodWin
*Version:     1.4
*/
if ( ! defined( 'ABSPATH' ) ) {
	echo '*Plugin Name: TSL plugin sitemap xml<br />';
	echo '*Plugin URI:  <a href="http://wpavonis.ru/tsl-plaginy/plagin-sozdanija-sitemap-xml-v-korne-sajta.html">http://wpavonis.ru/tsl-plaginy/plagin-sozdanija-sitemap-xml-v-korne-sajta.html<a><br />';
	echo '*Author URI:  <a href="http://wpavonis.ru/tsl-plaginy.html">http://wpavonis.ru/tsl-plaginy.html<a><br />';
	echo '*Description: Generated sitemap.xml for publish post and page<br />';
	echo '*Author:      GoodWin<br />';
	echo '*Version:     1.4<br />';
	exit;
}
function tsl_xml_sitemap ($home_priority='1.0', $page_priority='0.6', $post_priority='0.7', $other_priority = '0.3') {
   global $wpdb;
   $result = $wpdb->get_results("SELECT ID, post_modified_gmt, post_type FROM $wpdb->posts WHERE post_status='publish' ORDER BY post_modified_gmt DESC", 'ARRAY_A');
   if( !empty($result) ) 
   {
      $f = '<?xml version="1.0" encoding="UTF-8"?><urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">'. PHP_EOL;
      $dateplugin = date("F j, Y");
	 
      $f = $f.'<!-- Generated by TSL plugin sitemap '.$dateplugin.'-->'. PHP_EOL;
      $f = $f.'<!-- Version 1.3 -->'. PHP_EOL;
      $homepagesite = get_home_url().'/'; // добавлен слеш для сравнения со страницей далее
      $f = $f.'<url>'.PHP_EOL.'<loc>'.$homepagesite.'</loc><changefreq>daily</changefreq><priority>'.$home_priority.'</priority>'.PHP_EOL.'</url>' . PHP_EOL;
      $f = $f.'<!-- home page -->' . PHP_EOL;
      $count = 0; // счетчик для постов
      foreach ($result as $row)   
      {
         if ( $row['post_type'] == 'post' )
             {
             $priority = $post_priority;
             $count = $count + 1;
             $f = $f.'<url>'.PHP_EOL.'<loc>'.get_permalink($row['ID']).'</loc><changefreq>weekly</changefreq><priority>'.$priority.'</priority>'.PHP_EOL.'</url>' . PHP_EOL;               		
             }; 		
      }
      $f = $f.'<!-- total post = '.$count.' -->' . PHP_EOL;

      $count = 0; // счетчик для страниц
      foreach ($result as $row)   
      {
         if ( $row['post_type'] == 'page' )
             {
             $linkpage = get_permalink($row['ID']);
             if ( $homepagesite != $linkpage ) //страница как не главная
                {
                $priority = $page_priority;
                $count = $count + 1;
                $f = $f.'<url>'.PHP_EOL.'<loc>'.$linkpage.'</loc><changefreq>weekly</changefreq><priority>'.$priority.'</priority>'.PHP_EOL.'</url>' . PHP_EOL; 
              	}; 	
             }; 			
      }
      $f = $f.'<!-- total page = '.$count.' -->' . PHP_EOL;
      $f = $f.'</urlset>';
      $fp = fopen($_SERVER['DOCUMENT_ROOT'].'/sitemap.xml', 'w');
      fwrite($fp, $f);
      fclose($fp);
   }
   return;
}
add_action('transition_post_status', 'tsl_xml_sitemap', 1000, 0);
?>