<?php
/**
*Plugin Name: TSL plugin ampel seo picture
*Plugin URI:  http://wpavonis.ru/tsl-plaginy/plagin-analiza-izobrazhenij-v-zapisi-stranice.html
*Author URI:  http://wpavonis.ru/tsl-plaginy.html
*Description: SEO image analysis metabox in post & page
*Author:      GoodWin
*Version:     1.4
*/
//
if ( ! defined( 'ABSPATH' ) ) {
	include 'index.php'; // тк внутри условия - подключится по мере выполнения
    exit;
}

// HTML код блока
//function tsl_output_list_pic( $post, $meta ){
function tsl_output_list_pic( ){
//-------------------------------------------------------------------
	
// получаем из буфера данные со страницы в массив
global $post, $posts;                                                                                                                                               
ob_start();
ob_end_clean();
$output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches);
//это все ссылки страницы	
$rows = count($matches[1]); 	// длина массива, количество строк, tr	
//$output1 = preg_match_all('/href="([^"]+)"/', $post->post_content, $matches1);	
//echo '<pre>';
//print_r ($matches);
//echo '</pre>';	
//$matches[0] - картинки с тегами
//$matches[1] - картинки без тэгов

$attribute_arr = array();
//создаем массив с атрибутами Width / Height	
for ($new_c = 0; $new_c < $rows; $new_c++ ) {
	//ищем в полном тэге img $matches[0][$new_c]
	
    preg_match( '/width="(.*?)"/', $matches[0][$new_c], $matchesWidth);	
	// будет массив из двух элементов, строка width="80%" и значение 80%
	//echo '-----------------------------------------matchesWidth-'.count($matchesWidth).'<br/>';
	if ( count($matchesWidth) == 0) {
		//ничего не найдено - масссив равен 0
		$matchesWidth[0] = 'width=""';
		$matchesWidth[1] = '';
	}
	preg_match( '/height="(.*?)"/', $matches[0][$new_c], $matchesHeight);
	//echo '-----------------------------------------matchesHeight-'.count($matchesHeight).'<br/>';
	if ( count($matchesHeight) == 0) {
		//ничего не найдено - масссив равен 0
		$matchesHeight[0] = 'height=""';
		$matchesHeight[1] = '';
	}
	//аналогично
	
	$attribute_arr[$new_c] = array ($matches[1][$new_c], $matchesWidth[0], $matchesWidth[1], $matchesHeight[0], $matchesHeight[1] );
}

//создали массив вида $attribute_arr
//каждый элемет массива есть массив из элементов ниже
//  0     1          2      3         4
// урл width="70%"	70%  height=""    ""
// 
//echo $attribute_arr[0][0];
/*
echo '<pre>';
print_r ($attribute_arr);
echo '</pre>';
*/
//
//----------------------- супермассив -----------------------------------
//	
$sizes_tipe_arr = get_intermediate_image_sizes(); // получение списка названия наборов картинок	
// вручную к нашему массиву добавим full в качестве начального элемента
// все счетчики ниже будут корретно работать	
$sizes_tipe_count = array_unshift ($sizes_tipe_arr, 'full' );
// заодно и кол-во элементов новго массива возвращает	
// он простой линейный [0] и [1] и [2] и [3] - это для получения доп.данных нужно условия делать
$id_post_this = get_the_ID();
$media_arr = get_attached_media( 'image', $id_post_this);	// получим все медиа для данного поста
//echo $id_post_this;	
//echo '<pre>';
//print_r ($media_arr);
//echo '</pre>';		
$super_arr = gen_super_arr ($media_arr, $sizes_tipe_arr, $sizes_tipe_count );
//echo '<pre>';
//print_r ($super_arr);
//echo '</pre>';	
// 
// -----------------------------------------------------------------------------
// title для Kit с названиями зарегенных типов картинок - это только подсказка !!!
// тут full добавим вручную, тк это только подсказка - в других местах так нельзя, т.к по full есть запросы	
// для [0]
$title_kit_str = '[0] full <- original image &#10---&#10'; // // для [0]
// цикл начнем с [1]	
for ($title_c = 1; $title_c < $sizes_tipe_count; $title_c++ ) {
     $title_kit_str .= '['.$title_c.'] '.$sizes_tipe_arr[$title_c].' &#10';
	 if ($title_c == 4) {
		 $title_kit_str .= '---&#10'; // красивость, отделим --- для доп.размеров
	 }
}
$title_kit = ' title="'.$title_kit_str.'" ';
//-----------------------------------------------------------------------------	
if (has_post_thumbnail( $id_post_this )) {	
   $id_thumb = get_post_thumbnail_id( $id_post_this ); // получим id миниатюры данного поста
	// иначе вернет пустую строку, неудобно, пусть 0 будет......
} else {
   $id_thumb = 0;
}	
$thumb_url = wp_get_attachment_image_url( $id_thumb, 'thumbnail' ); 
//	
// эксперименты		
//echo $tsl_id.'<br/>';
//echo $tsl_kit_title;	
//echo '<pre>';
//print_r ($super_arr);
//echo '</pre>';
//echo '<pre>';
//print_r ($sizes_tipe_arr);
//echo '</pre>';	
// 
//	------------------------ стартовые переменные ----------------------------------------------
//
$domain_home = parse_url(get_home_url(), PHP_URL_HOST);	
$pic_size_total = 0; // сумма всех размеров картинок
// набор цветов для расскраски 0-зеленый, 1 - желтый, 2 - красный
$ampel_color_gl = -1;
// -1 - цвет так и не появился, 0, 1, 2 - как обычно
// если одно срабатывание красного = красный, далее аналогично	
$color_arr = array ('#98fb98', '#ffff00', '#FA8072' );
// знлнный, желтый, красный
$box_t = 'style="border: 1px solid black;"';	
$find_id_arr = array(); // 	массив для найденных ID	
$count_no_id = 0; // счетчик изображений без ID	
$thumb_key1 = FALSE; // результат поиска thumb в первой таблице	
//			
//	---------------------------начинаем собирать 1-ю таблицу---------------------------------------
//
$table = '<table width="100%" cellspacing="2" cellpadding="2" border="0">';
//первую 2 строки надо вне цикла нарисовать	
$table .= tsl_name_table ($box_t, $title_kit, TRUE)	;
// шапку 2 строки нарисовали
for ($tr=0; $tr < $rows; $tr++){ // построчная сборка, сначало вычисления
	//$pic_url = $matches[1][$tr];
	$pic_url = $attribute_arr[$tr][0];
    // -----------------------------------------------------------------------------
       $tmp_array = find_super_arr ($super_arr, $sizes_tipe_count, $pic_url, $thumb_url, $id_post_this);
       // разбираем на детальки
       $id_pic = $tmp_array[0]; // найденный id - в посте или в библиотеке!
       $kit_str = $tmp_array[1]; // раскраска kit строка
       $thumb_key = $tmp_array[2]; // наличие миниатюры
	   $res_post = $tmp_array[3]; // наличие в посте
	   $alien_post = $tmp_array[4]; // номер чужого поста или 0
	   if ($thumb_key) { // один раз за весь цикл
		  $thumb_key1 = $thumb_key ;
	   }
    //-------------------------------------------------------------------------------	
	$out_pic_arr = 	out_img_5 ($box_t, $pic_url, $domain_home, $color_arr);
	// массив: индикатор, 5 ячеек таблицы, размер (для итогового суммирования)
	$pic_size_total = $pic_size_total + $out_pic_arr[2]; // сумма всех размеров
	//
	//---------------------------------------------------------------------------------
	//вывод артрибутов
	$pos_atrr_w = $attribute_arr[$tr][1];
	if (preg_match( '/%/', $attribute_arr[$tr][2]) && empty(trim($attribute_arr[$tr][4]))) { //зеленый = % в ширине и пустота в высоте должна быть
		$pos_atrr = '<td align="center" bgcolor="'.$color_arr[0].'">'.$pos_atrr_w.'<br/>'.$attribute_arr[$tr][3].'</td>';
		$indik_attr = 0;
	} else { //все остальные варианты - красный
		$pos_atrr = '<td align="center" bgcolor="'.$color_arr[2].'">'.$pos_atrr_w.'<br/>'.$attribute_arr[$tr][3].'</td>';
		$indik_attr = 2;
	}
	//----------------------------------------------------------------------------------
	//
	$thumb_arr = array ($thumb_key, $id_thumb, $thumb_url );
	$out_str_arr = out_str_4 ($box_t, $id_pic, $pic_url, $res_post, $alien_post, $thumb_arr, $kit_str, $color_arr );
	// массив: индикатор, 4 последние ячейки
	//------------------------------------------------------------------------------
	// готовим вывод Ampel позже всех, тк нужно собрать информацию
    // будем красить ampel SEO
	// - первая часть готовится в выводе 5
	// - вторая часть готовится в выводе 3
	// если никакиз выводов цвета нет - но ни одно условие не сработает и $ampel_color_gl не изменинтся
	if ($out_pic_arr[0] == 2 || $out_str_arr[0] == 2 || $indik_attr == 2) { // если есть хотя бы один красный 
			$pos_ampel_color = '#FF0000';
		    if ($ampel_color_gl < 2) {
			   $ampel_color_gl = 2;	
			}
	} elseif ($out_pic_arr[0] == 1 || $out_str_arr[0] == 1 ) { // если есть хотя бы один желтый 
			$pos_ampel_color = '#FFFF00';
			if ($ampel_color_gl < 1) {
			   $ampel_color_gl = 1;	
			}
	} else { // зеленый -= остальное, могут быть отдельные желтые
			$pos_ampel_color = '#008000';
			if ($ampel_color_gl < 0) {
			   $ampel_color_gl = 0;	
			}
    }	
	$pos_ampel = '<td '.$box_t.' bgcolor="'.$pos_ampel_color.'"></td>';
	//------------------------------------------------------------------------------
	if ($id_pic > 0 && $res_post == 1) { // тут и "no id" добавим и в массив собранных id добавим
		$find_id_arr[] = $id_pic; // в массив собранных id добавим только для картинок, которые посту принадлежат
	} else {
		$count_no_id = $count_no_id + 1; // счетчик изображений без ID	
	}
	//------------------------ строка ------------------------------------!
	$table .= '<tr>'; //  начало строки                                   !
	//сборка строки таблицы = ампель + 5 поз + tr + tr + 3 поз            !
	$table .= $pos_ampel.$out_pic_arr[1].$pos_atrr.'<td>1920*1080</td>'.$out_str_arr[1];//                          !
	$table .= '</tr>'; // конец строки                                    !
	//--------------------------------------------------------------------!
}
//цикл строк с информацией закончился
if ($rows > 0) {	// шапку снизу для строк больше 0
   $table .= tsl_name_table ($box_t, $title_kit, FALSE); // 
}	
// последнюю строку отдельно с размером
$table .= '<tr><td colspan="2">Всего изображений: '.$rows.'</td><td>Итого: </td><th '.$box_t.'>'.$pic_size_total.' Kb</th></tr>';
if ($count_no_id > 0) {
   $table .= '<tr><td colspan="2">---</td></tr>';
   $table .= '<tr><td style="color:#FF0000" colspan="3"><strong>Не прикреплено картинок: '.$count_no_id.'</strong></td></tr>';
   $table .= '<tr><td style="color:#FF0000" colspan="3"><strong>Для них не будет работать srcset!</strong></td></tr>';
}
$super_arr = cut_super_arr ($super_arr, $find_id_arr); // коцаем
$count_super_arr = count($super_arr);

$thumb_key2 = FALSE; // результат поиска thumb во второй таблице		
if ($count_super_arr > 0) { //таблица для неучтенки
   $table .= '<tr><td> </td><td colspan="10"></td></tr>';	
   $table .= '<tr><td></td><th colspan="10">В списке зарегистрированных изображений поста есть еще '.$count_super_arr.' picture - в тексте поста нет!</th></tr>';	   
   $table .= '<tr><td> </td><td colspan="10"></td></tr>';	
   $table .= tsl_name_table ($box_t, $title_kit, TRUE)	; // шапка
   //------------------------------------------------------	
   foreach($super_arr as $key=>$value) { // построчная сборка, сначало вычисления
      // у нас теперь вывод массива с ключами
      // -----------------------------------------------------------------------------
       $pic_url = $super_arr[$key][0]; // это 0 нашего супермассива
       $tmp_array = find_super_arr ($super_arr, $sizes_tipe_count, $pic_url, $thumb_url, $id_post_this);
       // разбираем на детальки
       $id_pic = $tmp_array[0]; // найденный id 
       $kit_str = $tmp_array[1]; // kit с именами файлов в строке
       $thumb_key = $tmp_array[2]; // наличие миниатюры
	   if ($thumb_key) { // один раз за весь цикл
		  $thumb_key2 = $thumb_key ;
	   }
	 //------------------------------------------------------------------------------
	 $out_pic_arr = out_img_5 ($box_t, $pic_url, $domain_home, $color_arr);
	 // массив: индикатор, 5 ячеек таблицы, размер (для итогового суммирования)
	 // ---------------------------------------------------------------------------
	 $thumb_arr = array ($thumb_key, $id_thumb, $thumb_url );
	 $out_str_arr = out_str_4 ($box_t, $id_pic, $pic_url, 1, 0, $thumb_arr, $kit_str, $color_arr );
	 // массив: индикатор, 4 последние ячейки
     // здесь res_post всегда 1, т.к. чужой пост сюда не попадет
     // здесь alien_post всегда 0, он не нужен в выводе
	 //-----------------------------------------------------------------------------
	 if ($thumb_key) { //красим ampel только для строки с миниатюрой
		// будем красить ampel SEO
	    // - первая часть готовится в выводе 5
	    // - вторая часть готовится в выводе 3
	    if ($out_pic_arr[0] == 2 || $out_str_arr[0] == 2) { // если есть хотя бы один красный 
			$pos_ampel_color = '#FF0000';
			if ($ampel_color_gl < 2) {
			   $ampel_color_gl = 2;	
			}
	    } elseif ($out_pic_arr[0] == 1 || $out_str_arr[0] == 1 ) { // если есть хотя бы один желтый 
			$pos_ampel_color = '#FFFF00';
			if ($ampel_color_gl < 1) {
			   $ampel_color_gl = 1;	
			}
	    } else { // зеленый 
			$pos_ampel_color = '#008000';
			if ($ampel_color_gl < 0) {
			   $ampel_color_gl = 0;	
			}
        }	
	    $pos_ampel = '<td '.$box_t.' bgcolor="'.$pos_ampel_color.'"></td>'; 
	 } else {	
	    $pos_ampel = '<td '.$box_t.'></td>';	 
	 }
	 //----------------------------------------------------------------------! 
	 //сборка строки таблицы = без ампель + 5 поз + 3 поз                    !
	 $table .= '<tr>'; // начало строки                                      !
     $table .= $pos_ampel.$out_pic_arr[1].'<td>картинки нет в тексте</td><td>---</td>'.$out_str_arr[1];// 
	 $table .= '</tr>'; // конец строки                                      !
	 //----------------------------------------------------------------------! 
   }
   $table .= tsl_name_table ($box_t, $title_kit, FALSE); // шапку снизу	
}	
$table .= '</table>';
// таблица со статистикой
if ($thumb_key1) {
    $thumb_str1 = '<br/>(в том числе 1 миниатюра)'; 	
} else {
    $thumb_str1 = ''; 		
}
if ($thumb_key2) {
    $thumb_str2 = '<br/>(в том числе 1 миниатюра)'; 	
} else {
    $thumb_str2 = ''; 		
}
//
if ($ampel_color_gl == 2) { // если есть хотя бы один красный 
			$seo_ampel_color = 'bgcolor="#FF0000"';
} elseif ($ampel_color_gl == 1 ) { // если есть хотя бы один желтый 
			$seo_ampel_color = 'bgcolor="#FFFF00"';
} elseif ($ampel_color_gl == 0 ) { // зеленый
			$seo_ampel_color = 'bgcolor="#008000"';	
} else { // нет цвета - рамка
			$seo_ampel_color = '';
}		
//
$out_table = '<table style="width: 50%;" border="0">
<tr><td width="30" '.$box_t.$seo_ampel_color.' rowspan="3"></td><td '.$box_t.' rowspan="3">Всего картинок в посте: '.$rows.'<br/>Общий объем: '.$pic_size_total.' Kb</td><td '.$box_t.'>Из них без регистрации: '.$count_no_id.'</td><td></td></tr>
<tr><td '.$box_t.'>Из них с регистрацией: '.($rows - $count_no_id).$thumb_str1.'</td><td '.$box_t.' rowspan="2">Зарегено картинок в базе WP для данного поста: '.($rows - $count_no_id + $count_super_arr).'</td></tr>		
<tr><td '.$box_t.'>Зарегено, но нет в тексте поста: '.$count_super_arr.$thumb_str2.'</td></tr>
</table><br/>'.$table ;	

//echo $out_table;

//echo '<pre>';
//print_r ($find_id_arr);
//echo '</pre>';
//$super_arr = cut_super_arr ($super_arr, $find_id_arr);
//echo '<pre>';
//print_r ($super_arr);
//echo '</pre>';	
//echo count($super_arr);

//вовзращаем массив
// - сам вывод
// - объем
// - число картинок

$out_array = [$out_table, $pic_size_total, $rows];

return $out_array;

}

## Сохраняем данные, когда пост сохраняется
//add_action( 'save_post', 'myplugin_save_postdata' );
function myplugin_save_postdata( $post_id ) {
	// Убедимся что поле установлено.
	if ( ! isset( $_POST['myplugin_new_field'] ) )
		return;

	// проверяем nonce нашей страницы, потому что save_post может быть вызван с другого места.
	if ( ! wp_verify_nonce( $_POST['myplugin_noncename'], plugin_basename(__FILE__) ) )
		return;

	// если это автосохранение ничего не делаем
	if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ) 
		return;

	// проверяем права юзера
	if( ! current_user_can( 'edit_post', $post_id ) )
		return;

	// Все ОК. Теперь, нужно найти и сохранить данные
	// Очищаем значение поля input.
	$my_data = sanitize_text_field( $_POST['myplugin_new_field'] );

	// Обновляем данные в базе данных.
	update_post_meta( $post_id, 'my_meta_key', $my_data );
}
//---------------------------------------------------------------------------------------------
//
// HTML код блока сбоку
function tsl_ampel_side( $post, $meta ){
	echo '▲ <a href = "#">Переход в начало страницы</a><br/>';	
	$data_array = wp_cache_get( 'tsl_cache_key' );
	//общтй размер - фон
	// до 500 - зеленый
	// 500-1000 - желтый
	// более 1000 - красный
	if ($data_array[1] < 500) {
		$color_fon = '#98fb98'; // зеленый
	}elseif ($data_array[1] < 1000) {
		$color_fon = '#FFFF00'; // желтый
	}else{
		$color_fon = '#FA8072'; // красный
	}
	echo '<table style="width: 50%; border-collapse: collapse; background-color: '.$color_fon.';">
	<tr>
	<td style="width: 100%;"><b>Size '.$data_array[1].' Kb</b><br/><b>Pic '.$data_array[2].' </b> </td>
	</tr>
	</table>';
	
	echo '▼ <a href = "#ampel">Подробности SEO изображений</a>';	
}
//---------------------------------------------------------------------------------------------
//
function tsl_ampel_bottom( $post, $meta ){
	echo '<a id="ampel"></a>';
	// яеорь для показа  :)
	$data_array = wp_cache_get( 'tsl_cache_key' );
	//получаем из кэша наш массив с данными и выводим таблицу - которая первым элементом в массиве
	echo $data_array[0];
}


//---------------------------------------------------------------------------------------------
//
## Добавляем блоки в основную колонку на страницах постов и пост. страниц
add_action('add_meta_boxes', 'myplugin_add_custom_box');
function myplugin_add_custom_box(){
	$screens = array( 'post', 'page' );
	
	wp_cache_set( 'tsl_cache_key', tsl_output_list_pic() );
	
	$name_box = 'Анализ всех изображений поста: "'.esc_html(get_the_title()).'"';
	add_meta_box( 'metabox_table', $name_box, 'tsl_ampel_bottom', $screens );
	add_meta_box( 'metabox_navi', 'Светофор SEO images', 'tsl_ampel_side', $screens, 'side' );
}


//
//
//*******************************************************************************************
//
//
//
//             мои функции
//
//
//
//*******************************************************************************************
//type_jpg_word1 ($type_jpg) - тип файла
//tsl_ampel_jpg ($type_jpg, $color_arr) - заливка типа файла
//tsl_ampel_size ($pic_size, $color_arr) - заливка размера
//tsl_ampel_id ($id_pic, $color_arr) - заливка id
//tsl_ampel_thumb ()                  - заливка id 
//tsl_ampel_domen ($domain_url, $domain_home, $color_arr) - заливка домена
//tsl_name_table ($box_t, $title_kit, $key_2) - шапка таблицы (1 или 2 строки)
//out_img_5 ($box_t, $pic_url, $domain_home, $color_arr) - сборка первых 5 ячеек
//out_str_4 ($box_t, $id_pic, $pic_url, $res_post, $alien_post, $thumb_arr, $kit_str, $color_arr ) - сборка последних 4 ячеек
//gen_super_arr ($id_array, $sizes_tipe_arr, $sizes_tipe_count) - генератор супермассива
//find_super_arr ($super_arr, $sizes_tipe_count, $pic_url, $thumb_url) - поиск в супермассиве
//cut_super_arr ($super_arr, $find_id_arr) - обрезка супермассива
//
//
//
//
//
//
//---------------------------------------------------------------------------------------------
function type_jpg_word1 ($type_jpg) { // ругается на одинаковое название
if ($type_jpg == 1) {
         $type_t = 'GIF' ;                                                                               
} elseif ($type_jpg == 2) {
         $type_t = 'JPG' ;                                                                        
} elseif ($type_jpg == 3) {
	     $type_t = 'PNG' ;  
} elseif ($type_jpg == 4) {
	     $type_t = 'SWF' ; 
} elseif ($type_jpg == 5) {
	     $type_t = 'PSD' ; 
} elseif ($type_jpg == 6) {
	     $type_t = 'BMP' ; 	
} elseif ($type_jpg == 7) {
	     $type_t = 'TIFFi' ; 
} elseif ($type_jpg == 8) {
	     $type_t = 'TIFFm' ; 
} elseif ($type_jpg == 9) {
	     $type_t = 'JPC' ; 	
} elseif ($type_jpg == 10) {
	     $type_t = 'JP2' ; 
} elseif ($type_jpg == 11) {
	     $type_t = 'JPX' ; 	
} else {
	     $type_t = 'Unknown' ;                                                                         
}    	  	  
return $type_t;
}	
//
// ------------ заливки
//
function tsl_ampel_jpg ($type_jpg, $color_arr) { // выдача цвета для заливки типа
// рамку пока вручную, иначе надо везде добавить на вход $t_box	
if ($type_jpg == 1) { // gif
		 $indik = 1;
         $type_t = 'style="border: 1px solid black;"'; // не красим в желтый, т.к. не критично
} elseif ($type_jpg == 2) { // jpg
	     $indik = 0;
         $type_t = ' bgcolor="'.$color_arr[0].'"'; // зеленый 
} elseif ($type_jpg == 3) { // png
		 $indik = 1;
         $type_t = 'style="border: 1px solid black;"'; // не красим в желтый, т.к. не критично
} else {
	     $indik = 2;
	     $type_t = ' bgcolor="'.$color_arr[2].'"'; // красный
}    
// массив
// - индикатор
// - строка с окраской	
return array ($indik, $type_t) ;
}
//--------------------------------------------------------------------
//
function tsl_ampel_size ($pic_size, $color_arr) { // выдача цвета для заливки размера
if ($pic_size < 100) { 
	     $indik = 0;
         $type_t = ' bgcolor="'.$color_arr[0].'"'; // зеленый                     
} elseif ($pic_size < 150) { 
		 $indik = 1;
         $type_t = ' bgcolor="'.$color_arr[1].'"'; // желтый
} else {
	     $indik = 2;
	     $type_t = ' bgcolor="'.$color_arr[2].'"'; // красный  
}    	  	  
// массив
// - индикатор
// - строка с окраской	
return array ($indik, $type_t) ;
}
//-------------------------------------------------------------------
//
function tsl_ampel_id ($id_pic, $res_post, $box_t, $color_arr) { // выдача цвета для заливки ID
if ($id_pic > 0) { 
	    if ($res_post == 1) { // id картинки принадлежит текущему посту, зеленый
		    $indik = 0;
            $type_t = ' bgcolor="'.$color_arr[0].'"'; // зеленый 
		} elseif ($res_post == 3) {	// картинка принадледит чужому посту
			// покрасим в желтый, не повлияет на итог, т.к. прикрепление будет все равно красное
			$indik = 1;
            $type_t = ' bgcolor="'.$color_arr[1].'"'; // желтый
		} else { // id есть, но не прикреплено никуда
			$indik = 0;
            $type_t = ' style="border: 1px solid black;"'; // рамка
		}	
} else {
	$indik = 2;
	$type_t = ' bgcolor="'.$color_arr[2].'"'; // красный 
}	
// массив
// - индикатор
// - строка с окраской	
return array ($indik, $type_t) ;
}
//-------------------------------------------------------------------
//
function tsl_ampel_domen ($domain_url, $domain_home, $color_arr) { // выдача цвета для заливки домена
// сравниваем домен адреса картинки с текущим доменом	
if ($domain_url == $domain_home) { 
		 $indik = 0;
         $type_t = ' bgcolor="'.$color_arr[0].'"'; // зеленый                     
} else {
		 $indik = 2;
	     $type_t = ' bgcolor="'.$color_arr[2].'"'; // красный  
}    	  	  
// массив
// - индикатор
// - строка с окраской	
return array ($indik, $type_t) ;
}
//Image
//-------------------------------------------------
//
function tsl_name_table ($box_t, $title_kit, $key_2) { // шапка таблицы
// $box_t - рамка
// $title_kit - title  с массивом для Kit
// TRUE - две строки	
//рамка через style для ячеек
$table = '';
if ($key_2) { // если истина - рисуем первую строку
   $table .= '<tr><td width="30"> </td><th '.$box_t.' colspan="5">Server</th><th '.$box_t.' colspan="2">Data</th><th '.$box_t.' colspan="4">WordPress</th></tr>';
}	
// title для ячейки Ampel
$title_a = ' title="Светофор SEO: &#10  красный цвет - есть хотя один красный индикатор у картинки&#10  желтый цвет - есть хотя один желтый индикатор у картинки &#10  зеленый цвет - все индикаторы зеленые" ';	
// title для ячейки Tipe
$title_jpg = ' title="Фон ячеек зависит от типа: &#10  без цвета - GIF и PNG &#10  зеленый цвет - JPG  &#10  красный цвет - остальные типы картинок" ';	
// title для ячейки Size
$title_size = ' title="Фон ячеек зависит от размера файла: &#10  зеленый цвет - менее 100 Kb &#10  желтый цвет - от 100 Kb до 150 Kb &#10  красный цвет - 150 Kb и более" ';
// title для ячейки ID pic
$title_id = ' title="Ссылка - открытие картинки в новом окне &#10Фон ячеек зависит от наличия ID image: &#10  нет цвета - есть id в медиатеке WP, картинка не прикреплена &#10  зеленый цвет - есть id, прикреплено к текущему посту   &#10  желтый цвет - id картинки прикреплен к другому посту &#10  красный цвет - id картинки не найден " ';
// title для ячейки Post
$title_post = ' title="Фон ячеек зависит от прикрепления к посту: &#10  зеленый цвет - картинка прикреплена к текущему посту &#10  красный цвет - картинка не прикреплена к текущему посту" ';	
// title для ячейки Thumb
$title_thumb = ' title="Изображение используется в качестве миниатюры. &#10Фон ячейки зависит от размера: &#10  зеленый цвет - менее 10 Kb &#10  желтый цвет - от 10 Kb до 30 Kb &#10  красный цвет - 30 Kb и выше" ';
// title для ячейки Domen
$title_dom = ' title="Домен будет показан при наведении на ячейку &#10Сервер расположения картинки: &#10  зеленый цвет - our host &#10  красный цвет - bad host" ';	
$title_attr = ' title="Фон ячеек зависит от аттрибутов изображения в посте: &#10  зеленый цвет - width указан в процентах, height не установлен &#10  красный цвет - остальные варианты" ';	
$title_click = ' title="Фон ячеек зависит от изображения как ссылки в посте: &#10  зеленый цвет - картинка является ссылкой &#10  красный цвет - картинка не является ссылкой" ';	
// сборка второй строки заголовка		
$table .= '<tr><th '.$title_a.$box_t.'>SEO<sup>?</sup></th><th width = "130" '.$box_t.'>▼ Image</th><th '.$title_jpg.$box_t.'>Type<sup>?</sup></th><th '.$title_size.$box_t.'>Size<sup>?</sup></th><th '.$box_t.'>Dimm</th><th '.$title_dom.$box_t.'>Host<sup>?</sup></th><th '.$title_attr.$box_t.'>Attrib<sup>?</sup></th><th '.$title_click.$box_t.'>Full img<sup>?</sup></th><th '.$title_id.$box_t.'>ID image<sup>?</sup></th><th '.$title_post.$box_t.'>Post<sup>?</sup></th><th '.$title_thumb.$box_t.'>Thumb<sup>?</sup></th><th '.$title_kit.$box_t.'>Kit sizes<sup>?</sup></th></tr>';
return $table;
// ВЫХОД******************
}	
//
//----------------------------------------------------------
//
function out_img_5 ($box_t, $pic_url, $domain_home, $color_arr){
//функция будет генерить строку на 5 позиций таблицы (без первой ampel_seo)
//надо вернуть строку и индикатор по этим 5 позициям
//первые четыре позиции по ответу сервера
//5-я позиция - домен	
// на входе рамка, урл картинки, домашний домен, массив окраски
//*
//*
//*
// надо использовать имя файла с путем, а не урл - тк некоторые файлы могут быть http, а часть https!!!!
// ответа сервера может быть три: 200, 301- переадресация, 404 - нет url, хотя переменная может быть https, просто не включили 301...
// но в базе она ищется по url!!! тк как в коде страницы она в оригинале идет либо с http, либо с https
// те из урла надо получить название файла и сделать переменную с путем
// $pic_url - используется для вывода и проверки домена, $pic_path - для открытия файла и получения данных
//*
//*
$pic_path = $_SERVER['DOCUMENT_ROOT'].parse_url($pic_url, PHP_URL_PATH);
// корень + переменная с путем
//if (file_exists($pic_path)) {
//    $ttt = 'да'; 
//} else {
//    $ttt = 'нет'; 
//}
//
$data_arr = @get_headers(trim($pic_url), TRUE); //возвращает массив данных с заголовками о файле
// $data_arr['0'] - ответ сервера 200 - а вот и нет....
// strpos($data_arr['0'], '200')
// $data_arr['Content-Length'] - размер файла
//---------------------------------------------------------------------
// проверяем существование файла на сервере - а не ответ сервера по урл

$table_cell = '';

   if (file_exists($pic_path)) { // есть - собираем 4 нормальные ячейки
	   //$pic_size = round($data_arr['Content-Length']/1000); // в Кб! - если 301 кол - то будет ошибка
	   $pic_size = round(filesize($pic_path)/1000); // в Кб!
	   // размер файла по его пути, а не по url
	   $type_jpg_arr = getimagesize ($pic_url);   // возвращает массив - а тут работает даже при 301 коде
	   // тут тоже ошибка для gif
	   //$type_jpg_arr = array(100, 100, 2);
       // индекс 2 это флаг, указывающий тип изображения.1 = GIF, 2 = JPG, 3 = PNG 
       // индекс 0 - ширина, индекс 1 - высота
       // ----------------------------------------------------------
	   //используем размеры, что бы высокая картинка нам не крашила вывод
	   //надо как-то пересчитать высоту, если ширина 130....
	   //сжатие по ширине (коэффиц) = ширина картинки / 130 (ширина колонки 130)
	   //если расчетная высота выше 80 - то выводим 80
	   //в остальных - 130
	   //$tail_out - хвост для вывода размера
	   if ( $type_jpg_arr[0] > 0){ // почему-то у некоторых картинок 0 ширина!!! это gif дает ошибку!!
		if ( $type_jpg_arr[1] / ($type_jpg_arr[0] / 100 ) > 80){
			$tail_out = ' height = "80"'; 
		} else {	    
			$tail_out = ' width = "100%"';
		}
	   } else {
		   $tail_out = ' width = "100%"';
	   }
	   //наша картинка с title
       $title_pic = ' title="Click for open in a new window&#10'.$pic_url.'" ';
	   $pic_out = '<td width="130"><a href="'.$pic_url.'" target="_blank"><img src="'.$pic_url.'" '.$title_pic.' '.$tail_out.'></a></td>'; 
	   
   
	   // ------------------------------------------------------------------------------
	   // сборка ячейки JPG
	   $jpg_arr = tsl_ampel_jpg($type_jpg_arr[2], $color_arr );
	   $pos_jpg = '<td align="center" '.$jpg_arr[1].'>'.type_jpg_word1($type_jpg_arr[2]).'</td>';
	   //---------------------------------------------------------------------------------------
	   // сборка ячейки с размером
	   $size_arr = tsl_ampel_size($pic_size, $color_arr );
	   $pos_size = '<td align="center" '.$size_arr[1].'>'.$pic_size.' Kb</td>';
	   //---------------------------------------------------------------------------------------------
	   // сборка ячейки с dimm
	   $pos_dimm = '<td align="center">'.$type_jpg_arr[0].'*'.$type_jpg_arr[1].'</td>';
	   //---------------------------------------------------------------------------------------
	   $table_cell .= $pic_out.$pos_jpg.$pos_size.$pos_dimm;
	   // вычисляем индикатор
	   if ( $jpg_arr[0] == 2 || $size_arr[0] == 2) {
	   	   $indik = 2; // красное
	   } else {
	     if ( $size_arr[0] == 1) { // тип уже не интересует, он не критичный уже
	        $indik = 1; // желтый
	     } else { 
	        $indik = 0; // зеленый
	     }  	   
	   }
   } else	{ // собираем 3 ячейки в одну
	   $indik = 2; // сразу красное, т.к. файла нет
	   $pic_size = isset($data_arr['Content-Length'])?(int) $data_arr['Content-Length']:0;
	   // вариант битого файоа
	   if ($pic_size > 0) { // показываем ответ сервера по url - если физический файл не найден на сервере
		 $table_cell .= '<td bgcolor="'.$color_arr[2].'" colspan="4"><strong>'.$data_arr['0'].'<br/>'.$pic_url.'</strong></td>';
	   } else {   
		 $table_cell .= '<td bgcolor="'.$color_arr[2].'" colspan="4"><strong>'.$data_arr['0'].'<br/>'.$pic_url.'</strong></td>';   
	   }	   
   }
//добавляем хост, как 5-ю ячейку	
$domain_url = parse_url($pic_url, PHP_URL_HOST);
$title_dom = ' title = "'.$domain_url.'"';	
$dom_arr = tsl_ampel_domen($domain_url, $domain_home, $color_arr );
if ( $dom_arr[0] == 2) {
	$indik = 2; // индикатор красный, если домен чужой
	$dom_out = 'Bad';
} else {
	// индикатор не трогаем
	$dom_out = 'Our';
}	
// добавляем ячейку с доменом
// домен - он длинный, его надо в title спрятать 	
$table_cell .= '<td align="center" '.$dom_arr[1].$title_dom.'>'.$dom_out.'</td>';
// массив: индикатор, 5 ячеек таблицы, размер (для итогового суммирования)
return array ($indik, $table_cell, $pic_size  )	; 
// ВЫХОД******************
}	
//
//-----------------------------------------------------------------
//
function gen_super_arr ($id_array, $sizes_tipe_arr, $sizes_tipe_count){
// на входе массив ID картинок, которые зарегены на пост
// в самом посте может вообще не быть картинок :(	
// !!! $sizes_tipe_count - ранее коррекция с учетом типа full !!!!!!!
// ---------- начинаем создавать супермассив
$super_arr = array(); //пустой массив
$tmp_i = 0;	
foreach($id_array as $img){
   //при переборе запрашиваем ID из массива
   $tmp_id = $img->ID; // первый массив будет ассоциавным, это будут названия элементов
   // генерим временный массив для каждого ID
   $tmp_array = array(); // пустой временный массив на каждый цикл
   for ($tmp_c = 0; $tmp_c < $sizes_tipe_count; $tmp_c++ ) {
	  $tmp_array[] = wp_get_attachment_image_url( $tmp_id, $sizes_tipe_arr[$tmp_c]);  
   }
  // цепляем каждый временный массив к своему ID 	
  $super_arr[$tmp_id] = $tmp_array;
}
//	
// возврат супермассива
// первый массив - ассоциативный
// второй - обычный по номеру
//     key        0         1         2     3     4     5
//    1215     урл_full  урл_thumb   урл   урл            
// 	  2115     урл_full  урл_thumb   урл   урл               
// 	  2118     урл_full  урл_thumb   урл   урл    	
//echo '<pre>';
//print_r ($super_arr);
//echo '</pre>';
//exit;
return $super_arr;
// ВЫХОД******************      
}	
//
//----------------------------------------------------------------------------------------------------------
//
function find_super_arr ($super_arr, $sizes_tipe_count, $pic_url, $thumb_url, $id_post_this) {
// функция поиска данных в супермассивн
// вход
// - наш супермассив
// !!! $sizes_tipe_count - ранее коррекция с учетом типа full !!!!!!!
// - урл картинки - если картинка пустая, то
//   - не ищем совпадения
//   - только красим и провеяем thumb
// - урл миниатюры - проверка совпадения и для окраски	
// Что делаем:
// - ищем в цикле совпадение (имя файла берем как есть и сравниваем со всеми вариантами) с супермассивом и thumb - при совпадении красим
// - за пределами цикла делаем поиск урла (восстановленного) в базах WP (если не нашли в цикле и = 0)
//
// вот тут сложно - в посте картинки могут быть http / https и в супермассиве (что зарегано на пост) тоже могут быть вариант http / https
// те нужно сравнивать только часть урла с доменом - без протокола !!!
//
//
//
$pic_id = 0;     // 'no' потом в выводе
$kit_str = ''; 	
$key_win = FALSE;
$thumb_key = FALSE;		// совпадение с миниатюры
$res_post = 0; // 	принадлежность id данному посту	
// 1 - текущий пост
// 2 - есть в медиа и не принадлежит чужому посту
// 3 - есть в медиа и принадлежит чужому посту
$alien_post = 0; // номер чужого поста
// блин..........	
// ВАЖНО - супермассив вообще может быть 0, если на пост не зарегены картинки
// тогда остальной поиск уже в базах WP должен быть вне цикла!
foreach($super_arr as $key=>$value) {
	$thumb_key = FALSE;		// очистка - совпадение с миниатюры
	for ($type_c = 0; $type_c < $sizes_tipe_count; $type_c++ ) {
		$tag_beg = ''; 
        $tag_end = ''; 
		if (!empty($pic_url)) { // проверка $pic_url на пустоту
			// сравниваем только файл с доменом и путем - без протокола
			// домен / путь / файл
			$pic_url_cut = parse_url($pic_url, PHP_URL_HOST).parse_url($pic_url, PHP_URL_PATH); //собрали домен + путь (без протокола)
			$super_arr_cut = parse_url($super_arr[$key][$type_c], PHP_URL_HOST).parse_url($super_arr[$key][$type_c], PHP_URL_PATH); //собрали домен + путь (без протокола)
			// вот оно как
			if ( $pic_url_cut == $super_arr_cut ) {
				// успешно нашли id картинки в текущем посте 
				$pic_id = $key;
				$tag_beg = '<strong>'; 
				$tag_end = '</strong>'; 
				$key_win = TRUE; 
			}
		}	
        if ($thumb_url == $super_arr[$key][$type_c]){ // тут только окраска миниат если есть
		  $tag_beg = '<strong>'; 
		  $tag_end = '</strong>'; 
	    }
		$kit_str .= '['.$type_c.'] '.$tag_beg.wp_basename($super_arr[$key][$type_c]).$tag_end.'<br/>';
	}
	if ($key_win) {
	   $res_post = 1; // id картинки принадлежит текущему посту 	
	   if ($thumb_url == $super_arr[$key][1]){ // проверка миниатюры только после полного пробега
		   // с элементом [1] - иначе опять цикл крутить
	      $thumb_key = TRUE; 
	   }
	   // коцать массив будем отдельно, после всего вывода
	   break;	// выход из цикла for
	}
	$kit_str = '';	// обнуляем, если выход не по break и пошли на новый круг
}
//------------------------------------------------------	
// если в супермассиве нет - ищем в базах WP данный $pic_url вне цикла	
//	
$tmp_url = preg_replace('~-[0-9]+x[0-9]+(?=\..{2,6})~', '', $pic_url); // восттанавливаем первоначальное имя файла только здесь для поиска

$pic_id_media = 0;
if ($pic_id == 0) {
	// вот тут жесть на самом деле
	// картинка должна храниться в двух таблицах базы
	// в postmeta - быстрый поиск через attachment_url_to_postid
	// и в posts - медленный поиск по guid (причем можно сначала поискать по post_title - но там может быть некорректно записано)
	// сам WP всё правильно делает - но вот чужие плагины могут только в одной таблице posts зарегить (при синхронизации)
	// при поиске через медиатеку WP - целостность баз он восстанавливает 
	$pic_id_media = attachment_url_to_postid( $tmp_url ); // поиск в postmeta
	if ($pic_id_media == 0) {
	    // вот можно еще медленно поискать в основной таблице posts в базе
	    // двумя способами - быстрый (по post_title) и медленный (по guid)
		$pic_id_media = get_attachment_id_by_url( $tmp_url );
		// здесь только второй вариант по guid
	}   
}
if ($pic_id_media > 0 && $res_post == 0) { // id картинки нашли - он есть в медиатеке и $res_post по прежнему 0
	$pic_id = $pic_id_media;
	$alien_post = post_id_from_media_id( $pic_id ); // запрос к базе, ищем по id картинки, мы его уже знаем
	// номер чужого поста или 0 - если картинка свободная 
	if ($alien_post == 0) { // а теперь узнаем, этот id чужого поста или свободный
		  $res_post = 2; // id картинки есть в медиатеке и не зареген ни на кого
    } else {	 
		  $res_post = 3; // id картинки есть в медиатеке И ЗАРЕГЕН на чужой пост
	}	
}
//	
//-----------------------------------------------------	
// массив, 5 элементов
// - id картинки или 0
// - строку title_kit, уже раскрашенную (для миниатюру тоже покрасим потом)	
// - true - совпадение миниатюры с текущим id картинки
// res_post - прикрепление к данному посту
// $alien_post - номер чужого поста
return array ($pic_id, $kit_str, $thumb_key, $res_post, $alien_post);
// ВЫХОД******************
}
//
//-----------------------------------------------------------------------------------
//
function cut_super_arr ($super_arr, $find_id_arr) {
// будем коцать супермассив
// на входе
// - супермассив
// - массив найденных ID
$count_id = count ($find_id_arr);
//echo $count_id;
//exit();	
foreach($super_arr as $key=>$value) {
	// ключ $key поищем в массиве найденных ID
	//echo $key;
	//exit();
	for ($id_c = 0; $id_c < $count_id; $id_c++ ) {
		if ( $key == $find_id_arr[$id_c] ) { // есть совпадение
			unset ($super_arr[$key]); // чикаем этот элемент супермассива
		}
	}
}	
//	
// покоцанный супермассив
return $super_arr;
// ВЫХОД******************	
} 
//
//----------------------------------------------------
//
function out_str_4 ($box_t, $id_pic, $pic_url, $res_post, $alien_post, $thumb_arr, $kit_str, $color_arr ) {
//создание 4 последних ячеек
//$thumb_arr - массив с данными о миниатюре
// - 0 - его наличие
// - 1 - id thumb
// - 2 - url thumb    <a href="'.$pic_url.'" target="_blank">'.$id_pic.'</a>
// тут его покрасим  
//
// сборка ячейки с id 
$id_arr = tsl_ampel_id($id_pic, $res_post, $box_t, $color_arr );
if ($id_pic > 0) { // 
	    $pos_id = '<td align="center" '.$id_arr[1].'><a href= "'.$pic_url.'" target="_blank">'.$id_pic.'</a></td>';
} else {
		$pos_id = '<td align="center" '.$id_arr[1].'>no id</td>'; // 
}
//--------	
// сборка ячейки с res_post
if ( $res_post == 1) { // наш id
	$out_post = '<td align="center" bgcolor="'.$color_arr[0].'">'.$res_post.'Yes</td>'; 
} elseif ( $res_post == 2 ) {	//id есть в медиа и он не прикреплен
	$out_post = '<td align="center" bgcolor="'.$color_arr[2].'">'.$res_post.'No</td>'; 
} elseif ( $res_post == 3 ) {	//id есть в медиа и он прикреплен к чужому посту
	$url_post = get_permalink( $alien_post);
	$title_post = ' title = "'.get_the_title($alien_post).'"'; // title как название поста
	$out_post = '<td align="center" bgcolor="'.$color_arr[2].'"'.$title_post.'><a href="'.$url_post.'" target="_blank">'.$alien_post.'</a></td>'; 
} else {		
	$out_post = '<td align="center" bgcolor="'.$color_arr[2].'">'.$res_post.'No</td>';  
}
//--------------
// сборка ячейки с миниатюрой 
$thumb_key = $thumb_arr[0]; //bool
$id_thumb = $thumb_arr[1];
$thumb_url = $thumb_arr[2];
if ($thumb_key) { // он есть как зарегенный для данной картинки
	   $data_arr = @get_headers($thumb_url, TRUE); //возвращает массив данных с заголовками о файле
       // $data_arr['0'] - ответ сервера 200
       // $data_arr['Content-Length'] - размер файла
       if (strpos($data_arr['0'], '200')) { // есть файл
	       $thumb_size = round($data_arr['Content-Length']/1000); // в Кб!
           if ($thumb_size > 30) { // тут индикатор и покраска
			   $thumb_indik = 2; // красный	
			   $type_t = ' bgcolor="'.$color_arr[2].'"'; 
		   } elseif ($thumb_size > 9) {
			   $thumb_indik = 1; // желиый
			   $type_t = ' bgcolor="'.$color_arr[1].'"'; 
		   } else {	   
			   $thumb_indik = 0; // зеленый
			   $type_t = ' bgcolor="'.$color_arr[0].'"';  
		   }
		   $title_thumb = ' title= "id thumb ='.$id_thumb.'&#10Size = '.$thumb_size.' Kb&#10'.$thumb_url.'" ';
           $thumb_out = '<td align="center" '.$type_t.'><img src="'.$thumb_url.'" '.$title_thumb.' height="50"></td>';
	   } else {
		   $thumb_indik = 2;  // враги убили зарегенный thumb, а он там должен быть по всем базам
		   $thumb_out = '<td align="center" ><strong>File deleted!</strong></td>'; 
	   }	   
} else { // данная картинка не используется как миниатюра - пустое место
   $thumb_indik = 0;  // если его у данной картинки нет, то выдаем зеленый, ни на что не влияет
   // не красим 	
   $thumb_out = '<td> </td>';
}
//------------------------------------------------------------------------------
// сборка ячейки с Kit, уменьшаем шрифт
// пришлось рамку и шрифт тут вместе собрать
$kit_id = '<td style="border: 1px solid black; font: 11px arial;">'.$kit_str.'</td>';
//------------------------------------------------------------------------------
if ($id_pic == 0 || $thumb_indik == 2 || $res_post != 1) { // сборка indik: id, thumb, post)
   $indik = 2; // красное
} elseif ($thumb_indik == 1) { // желтый
   $indik = 1; // желтый
} else {
   $indik = 0; // зеленый	
}
//-----------------------------------------------------------------------------	
$table_cell = $pos_id.$out_post.$thumb_out.$kit_id;
// массив: индикатор, 4 последние ячейки таблицы
return array ($indik, $table_cell ); 
// ВЫХОД******************		
}
//
//-------- попытка получить номер поста по номеру картинки (на базе attachment_url_to_postid)
//только запрос к основной таблице, найти в ней ID (который теперь картинки) и вернуть post_parent
//если картинка не прикреплена к посту, должна вернуть 0 из базы
//
function post_id_from_media_id( $media_id ) {
    global $wpdb;
    $sql = $wpdb->prepare(
        "SELECT post_parent FROM $wpdb->posts WHERE post_type = 'attachment' AND ID = %s",
        $media_id
    );
    $post_parent = $wpdb->get_var( $sql );
    return (int) apply_filters( 'post_id_from_media_id', $post_parent, $media_id );
}
//
//
//-----------------------------------------------------------------
//
function get_attachment_id_by_url( $url ) {
    global $wpdb; 
    // таблица постов, там же перечисленны и медиафайлы
    $table  = $wpdb->prefix . 'posts';
    $attachment_id = $wpdb->get_var( 
        $wpdb->prepare( "SELECT ID FROM $table WHERE guid RLIKE %s", $url ) 
    );
    // Returns id
    return $attachment_id;
}
//
//---------------------------------------------------------------
//
//скрипт для прокрутки до якоря
function tsl_head_js1() { 
echo '<script type="text/javascript">
$(function(){
$("a[href*=#]").click(function() {
if (location.pathname.replace(/^\//,"") == this.pathname.replace(/^\//,"")
&& location.hostname == this.hostname) {
var $target = $(this.hash);
$target = $target.length && $target || $("[name=" + this.hash.slice(1) +"]");
if ($target.length) {
var targetOffset = $target.offset().top-100; //смещение
$("html,body").animate({scrollTop: targetOffset}, 1500);//скорость прокрутки
return false;
}
}
});
});
</script>
  '.PHP_EOL;
}
add_action ('admin_head', 'tsl_head_js1');
//
//
//
?>