<?php
/**
*Plugin Name: TSL plugin console robots
*Plugin URI:  http://wpavonis.ru/tsl-plaginy/plagin-metaboksa-konsoli-vyvod-fajla-robots-txt.html
*Author URI:  http://wpavonis.ru/tsl-plaginy.html
*Description: Addition metabox info robots.txt in console
*Author:      GoodWin
*Version:     1.5
*/
//
if ( ! defined( 'ABSPATH' ) ) {
	include 'index.php'; // тк внутри условия - подключится по мере выполнения
    exit;
}
//
function register_my_dashboard_widget_robots() {
     global $wp_meta_boxes;
     wp_add_dashboard_widget(
          'my_dashboard_widget_robots',
          'TSL info robots.txt',
          'my_dashboard_widget_display_robots'
     );
     $dashboard = $wp_meta_boxes['dashboard']['normal']['core'];
     $my_widget = array( 'my_dashboard_widget_robots' => $dashboard['my_dashboard_widget_robots'] );
     unset( $dashboard['my_dashboard_widget_robots'] );
     $sorted_dashboard = array_merge( $my_widget, $dashboard );
     $wp_meta_boxes['dashboard']['normal']['core'] = $sorted_dashboard;
}
add_action( 'wp_dashboard_setup', 'register_my_dashboard_widget_robots' );
//
//***********************************************************************************************************
//
function my_dashboard_widget_display_robots() {

//вывод переменных WP_SITEURL и WP_HOME - проверка корректности
$color_url_s = '';  //открывающий тэг - на старте пустышка
$color_home_s = ''; //открывающий тэг - на старте пустышка
$color_close = '';  //закрывающий тэг - на финише пустышка
//тут проверять будем только для https
if (is_ssl()) {
	if ( site_url('','https') == get_option('siteurl') ) {    //для WordPress
		$color_url_s = '<font color="green">';
	}else{
		$color_url_s = '<font color="red">';
	}	
	if ( home_url('','https') == get_option('home') ) {    //для home
		$color_home_s = '<font color="green">';
	}else{
		$color_home_s = '<font color="red">'; 
	}	
	$color_close = '</font>';
}
echo '<b title="Адрес WordPress (URL папки WP)&#10Настройки -> Общие">WP_SITEURL<sup>?</sup></b>: '.$color_url_s.get_option('siteurl').$color_close.'<br/>'; 	
echo '<b title="Адрес сайта (URL блога) &#10Настройки -> Общие">WP_HOME<sup>?</sup></b>: '.$color_home_s.get_option('home').$color_close.'<br/>'; 
//вывод данных сервера 
$list_server = "WEB - ".$_SERVER['SERVER_SOFTWARE']."<br />"."ROOT - ".$_SERVER['DOCUMENT_ROOT']."<br />"."HOST - ".$_SERVER['HTTP_HOST']."<br />"."HTTPS - ".$_SERVER['HTTPS']."<br />"."SCHEME - ".$_SERVER['REQUEST_SCHEME']."<br />"."PORT - ".$_SERVER['SERVER_PORT']."<br />"."HTTP ver - ".$_SERVER['SERVER_PROTOCOL']."<br />";
echo '<table border="1" width="100%">';
	echo '<tr><td>'.$list_server.'</td></tr>';	
echo ' </table>'; 
echo '<br/>';    

//получение двух файлов hhtp и https
stream_context_set_default( [
    'ssl' => [
        'verify_peer' => false,
        'verify_peer_name' => false,
    ],
]);
// загадочная фигня против кривых настроек сервера по SSL
// из-за кривых настроек может 200 возвращать по обоим запросам...

$robots_http = home_url('/','http').'robots.txt';
$kod_http = get_headers($robots_http, 1); 
//$strpos_kod_http = strpos($kod_http[0],'200');
//
$robots_https = home_url('/','https').'robots.txt';
$kod_https = get_headers($robots_https, 1); 
//$strpos_kod_https = strpos($kod_https[0],'200');
//
//если код 200 https и схема правильная - выводим два файла и только https синим
//если код 200 http - выводим только http синим
//если нет совсем - выводм ответ только для hhtp и сообщение красным, что нету...
// strpos - возвращает FALSE или номер позиции в строке...
// для https будет позиция 0 - так нельзя проверить
//
// только такой вариант проверки!
//
//   $result = strpos ($str, $substr);
//   if ($result === FALSE) // если это действительно FALSE, а не ноль, например 
//   или так if ($result !== FALSE) - тождественно не равно
// 
if (strpos($kod_https[0],'200') !== FALSE && is_ssl() ) { // есть 200 https и есть SSL
	echo $robots_http.' - '.$kod_http[0].'<br/>';
	echo '<b><font color="blue">'.$robots_https.'</font></b>  - '.$kod_https[0].'<br/>';
} elseif (strpos($kod_http[0],'200') !== FALSE) { // есть 200 http
    echo '<b><font color="blue">'.$robots_http.'</font></b>  - '.$kod_http[0].'<br/>';
} else { // если нигде нет 200
	echo $robots_http.' - '.$kod_http[0].'<br/>';
	echo $robots_https.' - '.$kod_https[0].'<br/>';
	echo '<b><font color="red">File robots.txt not found !</font></b><br/>'; 
	return;	  
   // ВЫХОД ******************
}

// проверим на реальность - название файла с путем сервера
$robots_real = $_SERVER['DOCUMENT_ROOT'].'/robots.txt';
if (file_exists($robots_real)) {
    echo 'Файл robots.txt физически существует на сервере';
} else {
    echo 'Файл robots.txt виртуальный';
}

//определение файла robots.txt для URL
$name_file = $robots_http;  // по умолчанию
if (strpos($kod_https[0],'200')) { // 200 для https
   $name_file = $robots_https;  	 
} 
 
//-----------------------------------------------------	
//получение в переменную списка вывода
$lines = file($name_file);
// Осуществим проход массива и соберем в виде HTML-кода строки
$list_robots_txt = '';
foreach ($lines as $line_num => $line) {
    $list_robots_txt .= htmlspecialchars($line).'<br />';
}
echo '<table border="1" width="100%">';
	echo '<tr><td>'.$list_robots_txt.'</td></tr>';	
echo ' </table>';   
}
//
?>