<?php
/**
*Plugin Name: TSL plugin out list posts
*Plugin URI:  http://wpavonis.ru/tsl-plaginy/plagin-vyvoda-anonsov-postov-v-konce-kontenta.html
*Author URI:  http://wpavonis.ru/tsl-plaginy.html
*Description: Addition out list of posts in end of content
*Author:      GoodWin
*Version:     2.3
*/
//--------------------------------------------
if ( ! defined( 'ABSPATH' ) ) {
	include 'index.php'; // тк внутри условия - подключится по мере выполнения
    exit;
}
// переменная $content существует до начала фунции - в неё записан сам пост
// туда её фильтр передает....
// для вывода после к ней надо добавить наше творение, для вывода до - добавить спереди
// можно добавлять внутри функции $content = $content.'текст'
function tsl_end_text( $content ){
	// выводим последние записи по автору/рубрике
	// если одна запись - ничего не выводим
	$text = ''; //пустышка для начала
	$add_file = $_SERVER['DOCUMENT_ROOT'].'/tslmyadd.php';
	if (is_front_page()){
		//для главной - пустышку
		$add_cont = '';
	}else{ // не главная - можно было одним if - но лучше для главной даже не запрашивать наличие файла
		if ( !file_exists($add_file) ){
			//file() - там false только при ошибке чтения
			//если файл не существует - будет ошибка PHP
			//начального файла нет
			$add_cont = '';
		}else{
			include_once $add_file;
			//появится переменная $add_cont из этого файла
			if (! isset($add_cont)) { //что-то в файое криво
				$add_cont = 'error...';
			}
		}
	}


	$text = $add_cont.'<br />'.$text;
	
	//*****посты********************************************

	if (is_single()) { 
		$current_post = get_the_ID(); // получаем в самом начале ID текущего поста - уберем его из вывода
		
		$mytype_post = get_post_type($current_post); 
		//текущий тип поста
		
		$cat = get_the_category(); // массив с данными о категориях данного поста
		if (empty($cat[0])) { // для пустных категория - для кастомных типов
			return $content;
		//ВЫХОД - возвращаем контент без изменений
		}
		//вот тут выкидываем для постов без категорий...
		
		if ($cat[0]->count == 1) { // только одна запись в категории
			return $content;
		//ВЫХОД - возвращаем контент без изменений
		}
			
		$args['posts_per_page'] = 8; // в реальности будет 7, тк исключим текущий пост
		$args['order'] = 'DESC';
		$args['orderby'] = 'date';
		
		$args['post_type'] = $mytype_post;
		//тип поста взять у текущего, а не = 'post'
		
		$args['post_status'] = 'publish';
		$args['cat'] = $cat[0]->term_id;  // вытаскиваем номер категории из массива - 0 - это для первой категории типа $cat[0][term_id]
		
		$post_array = get_post($current_post); // данные текущего поста
		// отсюда потом автора вытащим
		$args['author'] = $post_array->post_author; // аналогично - цифра ID
		
		$result_q = new WP_Query($args);
		//echo '<pre>';
		//print_r ($result_q);
		//echo '</pre>';
				
		//вывод даты только для типа 'post'
		if ($mytype_post == 'post') {
			$date_out = True;
		}else{
			$date_out = False;			
		}
		
		$add_text = '';
		while ( $result_q->have_posts() ) {
			$result_q->the_post(); // двигаем указатель внутри глобального массива, сформированного WP_Query
			$id_out = get_the_ID(); // это уже внутри этого массива
			if ( $id_out != $current_post) { // исключаем текущую запись
				$add_text_curr = tsl_echo_content( $id_out, $date_out ); // собираем вывод в переменную
				$add_text = $add_text.$add_text_curr;   
			}
		}
		
		wp_reset_postdata(); // после сборки вывода возращает все указатели на текущий пост
		
		
		
		//немного паранойи, не показываем логин 
		$user_login = get_the_author_meta('user_login', $args['author']); // логин
		$user_nick = get_the_author_meta('nickname', $args['author']); // ник
		// user_nicename - это слаг для URL автора, который авт. формируется из логина по опр. правилам - можно через плагин изменить потом
		// его не надо проверять
		
		$author_nick = get_the_author_meta('display_name', $args['author']); // отображаемое имя
		$author_link = get_author_posts_url( $args['author'] );
		
		if ($author_nick == $user_login) { // если display_name совпадает с логином
			$author_nick = $user_nick;
			if ($user_nick == $user_login) { // проверяем Nick - если везде логины - заглушка
				$author_nick = 'Автор';
				$author_link = home_url(); //линк на главную
			}	
		}
		// вторая проверка - прячем варианты Admin, Administrator - без учета регистра, по русски - Администратор
		if ( strcasecmp($author_nick, 'admin') == 0 || strcasecmp($author_nick, 'administrator') == 0 || $author_nick == 'Администратор' ) {
			$author_nick = 'Автор';
			$author_link = home_url(); //линк на главную
		}
		
		//$text - задаем в самом начале
		$text = $text.'<h3>Последние публикации</h3>';
				$str_1[0] = '<b>Статьи от:</b> ';
				$str_1[1] = $author_nick;
				$str_1[2] = $author_link; // может быть заглушка
				$str_2[0] = '<b>Рубрика:</b> ';
				$str_2[1] = get_cat_name( $args['cat'] );
				$str_2[2] = get_category_link( $args['cat'] );
				$str_3[0] = '<b>Сортировка:</b> ';
				$str_3[1] = 'дата публикации по убыванию';
		$text = $text.tsl_echo_3ul($str_1, $str_2, $str_3).$add_text;  //подцепим наш вывод из цикла
		
	}
// страницы**********************************************************************************************************************
	if (is_page()) { 
	
	//логика
	//на верхнем уровне выводим список дочерних страниц
	//на нижнем уровне выводим список страниц одного уровня и сслыку на основной верхний раздел
	//на среднем уровне надо вывести список дочерних страниц и ссылку на основной верний раздел
		//--------------------------------
		$current_page = get_the_ID(); // получаем в самом начале ID текущей страницы
		
		$arr_ancestors = get_ancestors( $current_page, 'page' ); // массив!!! - тк может быть многоуровневое вложения страниц
		//получаем родительские страницы
		//Массив идентификаторов (ID) родительских элементов, где последняя ячейка массива будет содержать ID самого верхнего элемента цепочки.
		
		//echo '<pre>';
		//print_r($arr_ancestors);
		//echo '</pre>';
		
		
		$parrent_home  = 0; //задаем ноль для id верхнего уровня
		$count_arr = count($arr_ancestors); // размер массива
		if ($count_arr >0) {
			//для массива из одного элемента они совпадут
			$parrent_home  = end($arr_ancestors);
			$parrent_page = array_shift($arr_ancestors); //если массив не пустой - получаем первый элемент - ID родителя
			//функция array_shift извлекает первый элемент и удаляет его из массива!
		}else{
			$parrent_page = 0;
		}
		
		//echo 'текущая страница '.$current_page;
		//echo '<br/>$parrent_home '.$parrent_home;
		//echo '<br/>$parrent_page '.$parrent_page;

		// итого получили три параметра
		//
		// размер массива $count_arr
		// топстраницу $parrent_home
		// родительскую страницу $parrent_page
		
		//--------------------------------
	
		$args['posts_per_page'] = -1; // нам нужно всё
		$args['order'] = 'ASC'; // надо сортировку по возрастанию
		$args['orderby'] = 'title'; // надо по названиию
		$args['post_type'] = 'page';
		$args['post_status'] = 'publish';
		
		$args['post_parent'] = $current_page;
		
		//if ($parrent_page > 0) {
		//	$args['post_parent'] = $parrent_page; // для вывода страниц одного уровня при наличии родителя
			//$args['post__not_in'] = array($current_page); // исключаем текущую страницу из выборки - здесь массив из одного элемента
			//удобно - но так нельзя - иначе общее число страниц в разделе неправильно потом посчитаем
		//}
		
		// знатное извращение - выборка дочерних страниц - если указан параметр родительской страницы
		// для получения страниц одного уровня - нужно узнать родительскую для текущей
		// и указать в параметре 
		// post_parent - число - для одной родительской странцы
		// post_parent__in  -массив - для нескольких родительских страниц
		
		$result_q = new WP_Query( $args );
		
		$i_total = 0; // всего дочерних страниц
		$i_out = 0; // показано дочерних страниц
			
		$add_text = '';
		while ( $result_q->have_posts() ) { // если в выводе что-то есть
			$i_total = $i_total + 1; //считаем число страниц
			$result_q->the_post(); // двигаем указатель внутри глобального массива, сформированного WP_Query
			$id_out = get_the_ID(); // это уже внутри этого массива
			if ( $id_out != $current_page) { // исключаем текущую страницу
				$add_text_curr = tsl_echo_content( $id_out, FALSE ); // собираем вывод в переменную, без даты
				if (!empty($add_text_curr)) {
					$i_out = $i_out + 1; //считаем вывод дочерних страниц
				}
				$add_text = $add_text.$add_text_curr;
			}
		}
		wp_reset_postdata(); // после сборки вывода возращает все указатели на текущий пост
			
		//echo '<br/>$i_out '.$i_out;

		if ($i_out == 0) { // нет дочерних страниц для вывода (или не нашлось с инфо) - ищем одноуровневые
			$i_total = 0; // всего страниц - обнуляем заново
			if ($count_arr >0) { //если нет родителей выше - ничего не делаем = для топ страницы не нужен вывод одноуровневых
				$args['posts_per_page'] = -1; // нам нужно всё
				$args['order'] = 'ASC'; // надо сортировку по возрастанию
				$args['orderby'] = 'title'; // надо по названиию
				$args['post_type'] = 'page';
				$args['post_status'] = 'publish';
				$args['post_parent'] = $parrent_page; // указываем род страницу
					
				$result_q = new WP_Query( $args );
					
				$add_text = '';
				while ( $result_q->have_posts() ) {
					$i_total = $i_total + 1; //считаем число страниц
					$result_q->the_post(); // двигаем указатель внутри глобального массива, сформированного WP_Query
					$id_out = get_the_ID(); // это уже внутри этого массива
					if ( $id_out != $current_page) { // исключаем текущую страницу
						$add_text_curr = tsl_echo_content( $id_out, FALSE ); // собираем вывод в переменную, без даты
						if (!empty($add_text_curr)) {
							$i_out = $i_out + 1; //считаем вывод  страниц
						}
						$add_text = $add_text.$add_text_curr;
					}
				}
				wp_reset_postdata(); // после сборки вывода возращает все указатели на текущий пост
					
			}
			
		}
		// шапка
		//$text = '';
		//$text - задаем в самом начале
		if ($i_out > 0) { //вывод шапки, если есть что выводить
			if ($parrent_home > 0 && $parrent_home!=$args['post_parent']) { // верхний уровнь если есть
				$text = $text.'<h3>Основной раздел</h3>';
				//вот тут фотку и лписание вытащить
				$text .= tsl_echo_content( $parrent_home, FALSE ); // собираем вывод верхнего уровня, без даты
			}
			$text = $text.'<h3>Почитать в разделе</h3>';
			//вот тут фотку и лписание вытащить
			$text .= tsl_echo_content( $args['post_parent'], FALSE ); // собираем вывод верхнего уровня, без даты
			$str_1[0] = '<b>Всего статей в разделе:</b> ';
			$str_1[1] = $i_total;
			$str_2[0] = '<b>Показано статей в списке:</b> ';
			$str_2[1] = $i_out;
			$str_3[0] = '<b>Сортировка:</b> ';
			$str_3[1] = 'название по алфавиту';
			$text = $text.tsl_echo_3ul($str_1, $str_2, $str_3).$add_text;  //подцепим наш вывод из цикла
		}

	}
	return $content.$text;
}
add_filter('the_content', 'tsl_end_text', 9999999);
//
//
//
//**********************************************
//
//
function tsl_echo_content( $id_out, $out_date ){
// на входе ничего не нужно - тк мы находимся внутри массива постов - каждый раз новый пост
// но пусть будет ID
// $out_date - необходимость вывода даты
$first_cut = mb_substr(get_post_field('post_content', $id_out), 0, 2500);
//нужен запас по символам, тк там много тэгов
$first_cut = trim(filter_var($first_cut, FILTER_SANITIZE_STRING)); //  без html и пробелов по краям
$first_cut = mb_substr($first_cut, 0, 700); // обрезка на 700 уже без html
//ищем пробел справо налево
$pos_space = mb_strrpos($first_cut, ' ');
if ($pos_space !== FALSE) {
	$first_cut = mb_substr($first_cut, 0, $pos_space);
}		
//---------------------------------------------------------------------------------
$content_my = $first_cut;
// если контент пустой - возвращаем пустышку
if ( empty($content_my) ) {
	$text = '';   
	return $text;
	//ВЫХОД
}
$link_my = get_permalink($id_out);
$title_my = get_the_title($id_out);
			
$thumb_url = get_the_post_thumbnail_url($id_out, 'thumbnail' ); // или FALSE или урл
$thumb_out = '';
if ( $thumb_url !== FALSE) { //конструируем вывод картинки, если она есть
	$thumb_out = '<a href="'.$link_my.'"><img style="margin:6px 6px 0px 0px; float:left;" src="'.$thumb_url.'" width="130" height="130" ></a>';
}
if ( $out_date ) {
	$date_my = '<b>'.get_the_date().'</b><br/>';
	$date_hum = '<i> Публикация '.human_time_diff( get_post_time('U'), current_time('timestamp') ).' назад</i><br/>';
}else{
	$date_my = '';
	$date_hum = '';
}	
$out_title = '<a href="'.$link_my.'"><h4>'.$title_my.'</h4></a>';
$out_cont_read = $date_my.$date_hum.$content_my.'...<br/><a href="'.$link_my.'"> (Читать полностью...)</a>';			
$text = $out_title.$thumb_out.$out_cont_read;
// тут нам надо отменить обтекание для завершающей линии - <div style="clear: left; float:none;">test</div>
$text = $text.'<div style="clear: left; float:none;"><hr></div>';   
return $text;	
}
//
//----------------------------------------------
//
function tsl_echo_3ul( $str_1, $str_2, $str_3){
	// $str_1 - массив с данными для 1 строки = строка, перемеменная, ссылка
	// $str_2 - массив с данными для 1 строки = строка, перемеменная, ссылка
	// $str_3 - массив с данными для 1 строки = строка, перемеменная, ссылка
	$text = '<ul>';
	if ( isset( $str_1[2] )) { // переменная со ссылкой существует и она не пустая
		$text = $text.'<li>'.$str_1[0].'<a href="'.$str_1[2].'">'.$str_1[1].'</a></li>';
	}else{
		$text = $text.'<li>'.$str_1[0].$str_1[1].'</li>';
	}
	if ( isset( $str_2[2] )) { // переменная со ссылкой существует и она не пустая
		$text = $text.'<li>'.$str_2[0].'<a href="'.$str_2[2].'">'.$str_2[1].'</a></li>';	
	}else{
		$text = $text.'<li>'.$str_2[0].$str_2[1].'</li>';
	}
	if ( isset( $str_3[2] )) { // переменная со ссылкой существует и она не пустая
		$text = $text.'<li>'.$str_3[0].'<a href="'.$str_3[2].'">'.$str_3[1].'</a></li>';	
	}else{
		$text = $text.'<li>'.$str_3[0].$str_3[1].'</li>';
	}
	$text = $text.'</ul>';
return $text;
// возвращаем сборку
}
?>