<?php
/**
*Plugin Name: TSL plugin list author
*Plugin URI:  https://wpavonis.ru/tsl-plaginy/plagin-vyvoda-spiska-avtorov-bloga-vidzhet.html
*Author URI:  https://wpavonis.ru/tsl-plaginy.html
*Description: Displaying a list of blog authors
*Author:      GoodWin
*Version:     1.3
*/

if ( ! defined( 'ABSPATH' ) ) {
	include 'index.php'; // тк внутри условия - подключится по мере выполнения
    exit;
}

// Регистрация и активация виджета
// Функция и класс называются одинаково

function tls_plagin_list_authors_widget() {
	register_widget( 'tls_plagin_list_authors_widget' );
}
add_action( 'widgets_init', 'tls_plagin_list_authors_widget' );

class tls_plagin_list_authors_widget extends WP_Widget {

	function tls_plagin_list_authors_widget() {
		$widget_ops = array( 'classname' => 'example', 'description' => __('Список авторов блога с аватарами', 'example') );
		
		$control_ops = array( 'width' => 300, 'height' => 350, 'id_base' => 'widget_list_authors_tsl' );
		
		$this->WP_Widget( 'widget_list_authors_tsl', __('TSL List author Widget', 'example'), $widget_ops, $control_ops );
		// widget_list_authors_tsl - название виджета в базе
		// и выше тоже
	}
	
	public function widget( $args, $instance ) {
		extract( $args );
		//Значения, содержащиеся в $args (тэги html), задаются активной темой при регистрации области боковой панели.
		//В конструкции вывода они должны быть
		//После extract появляются переменные (вместо индекса в массиве) с тегами
		//Или так можно echo $args['before_widget'] . $args['before_title'] . $title . $args['after_title'];

		//Our variables from the widget settings.
		$title = apply_filters('widget_title', $instance['title'] );
		$count_a = $instance['count_a']; // число авторов для вывода - из настроек
		//$show_info = isset( $instance['show_info'] ) ? $instance['show_info'] : true;
		$show_info = $instance['show_info'];

		echo $before_widget;		
		
		// Display the widget title 
		if ( $title )
			echo $before_title . $title . $after_title;
		
		// order=DESC - сортировка по убыванию 
		// orderby=post_count - сортировка по счетчику постов
		// number=3 - три автора макс
		// $show_info - показ мыла, если true
		tsl_list_authors('show_fullname=1&optioncount=1&orderby=post_count&order=DESC&number='.$count_a, $show_info);
	
		echo $after_widget;
	}

	//Update the widget 
	 
	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		//Strip tags from title and count_a to remove HTML 
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['count_a'] = strip_tags( $new_instance['count_a'] );
		$instance['show_info'] = $new_instance['show_info'];

		return $instance;
	}


	public function form( $instance ) {

		//Set up some default widget settings.
		// checked - показ что есть (без равно для html и ="checked" для XHTML)  - вместо value для остальных полей
		// почему-то функция checked() тут не хочет работать...сделал через if
		//  checked(true, $instance['show_info'], true ); 
		$defaults = array( 'title' => __('Авторы', 'example'), 'count_a' => __('3', 'example'), 'show_info' => true );
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>

		<p>
			<label><?php _e('Заголовок:', 'example'); ?>
			<input name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" style="width:100%;" />
			</label>
		</p>
		<p>
			<label><?php _e('Число авторов (1-10):', 'example'); ?>
			<input type="number" size="2" min="1" max="10" name="<?php echo $this->get_field_name( 'count_a' ); ?>" value="<?php echo $instance['count_a']; ?>" />
			</label>
		</p>
		<p>
			<label><?php _e('Показать email автора?', 'example'); ?>
			<input type="checkbox" name="<?php echo $this->get_field_name( 'show_info' ); ?>" <?php if ( $instance['show_info'] ) echo 'checked="checked"'; ?>   /> 
			<?php  
			//if ($instance['show_info']) {
			//		echo 'Yes';
			//}
			//echo checked( true );
			?>
			</label>
		</p>
	<?php
	}
}
//
//--------------------------------------------------------------------------------
//собственно вывод инфо
//модификация на основе базовой функции WP - wp_list_authors
function tsl_list_authors( $args = '', $show_mail ) {
	global $wpdb;

	$defaults = array(
		'orderby'       => 'name',
		'order'         => 'ASC',
		'number'        => '',
		'optioncount'   => false,
		'exclude_admin' => true,
		'show_fullname' => false,
		'hide_empty'    => true,
		'feed'          => '',
		'feed_image'    => '',
		'feed_type'     => '',
		'echo'          => true,
		'style'         => 'list',
		'html'          => true,
		'exclude'       => '',
		'include'       => '',
	);

	$args = wp_parse_args( $args, $defaults );

	//начало формирования переменной для вывода
	$return = '<table style="border-collapse: collapse; width: 100%;">';

	$query_args           = wp_array_slice_assoc( $args, array( 'orderby', 'order', 'number', 'exclude', 'include' ) );
	$query_args['fields'] = 'ids';
	$authors              = get_users( $query_args );

	$author_count = array();
	foreach ( (array) $wpdb->get_results( "SELECT DISTINCT post_author, COUNT(ID) AS count FROM $wpdb->posts WHERE " . get_private_posts_cap_sql( 'post' ) . ' GROUP BY post_author' ) as $row ) {
		$author_count[ $row->post_author ] = $row->count;
	}
	foreach ( $authors as $author_id ) {
		
		
		
		$posts = isset( $author_count[ $author_id ] ) ? $author_count[ $author_id ] : 0;

		if ( ! $posts && $args['hide_empty'] ) {
			continue;
		}

		$author = get_userdata( $author_id );

		if ( $args['exclude_admin'] && 'admin' === $author->display_name ) {
			continue;
		}

		if ( $args['show_fullname'] && $author->first_name && $author->last_name ) {
			$name = "$author->first_name $author->last_name";
		} else {
			$name = $author->display_name;
		}

		if ( ! $args['html'] ) {
			$return .= $name . ', ';

			continue; // No need to go further to process HTML.
		}

		$return .= '<tr>'; // начало строки
		
		//аватар
		$size_avatar = 60; // ширина аватара
		$img_avatar = get_avatar( $author_id, $size_avatar, 'identicon', $name, array( 'extra_attr'=>'title="Посмотреть записи автора"') );
		//выдает готовый тэг img, заменяемая функция может быть заменена плагином
		//четвертый параметр - это Alt
		$url_author = get_author_posts_url( $author->ID, $author->user_nicename );
		$foto_avatar = '<a href="'.$url_author.'">'.$img_avatar;
		$return .= '<td width="'.$size_avatar.'">'.$foto_avatar.'</td>'; // первая ячейка с фото - ширина под фото
				
		$return .= '<td>'; // вторая ячейка с данными
		
		if ( 'list' == $args['style'] ) {
			$return .= ''; // тут раньше было <li>
		}

		$link = sprintf(
			'<a href="%1$s" title="%2$s">%3$s</a>',
			get_author_posts_url( $author->ID, $author->user_nicename ),
			/* translators: %s: Author's display name. */
			esc_attr( sprintf( __( 'Posts by %s' ), $author->display_name ) ),
			$name
		);

		if ( ! empty( $args['feed_image'] ) || ! empty( $args['feed'] ) ) {
			$link .= ' ';
			if ( empty( $args['feed_image'] ) ) {
				$link .= '(';
			}

			$link .= '<a href="' . get_author_feed_link( $author->ID, $args['feed_type'] ) . '"';

			$alt = '';
			if ( ! empty( $args['feed'] ) ) {
				$alt  = ' alt="' . esc_attr( $args['feed'] ) . '"';
				$name = $args['feed'];
			}

			$link .= '>';

			if ( ! empty( $args['feed_image'] ) ) {
				$link .= '<img src="' . esc_url( $args['feed_image'] ) . '" style="border: none;"' . $alt . ' />';
			} else {
				$link .= $name;
			}

			$link .= '</a>';

			if ( empty( $args['feed_image'] ) ) {
				$link .= ')';
			}
		}

		// число постов и ссылка на автора
		if ( $args['optioncount'] ) {
			//$link .= '<br />' . $posts . ' post';
			$link .= '<br /><a href="'.$url_author.'">'.$posts.' post</a>';
		}

		$return .= $link;
		$return .= ( 'list' == $args['style'] ) ? '<br />' : ', ';
		
		//закрытие второй ячейки и строки
		$return .= '</td></tr>';
		
		// ----- вывод почты -------------------
		if ($show_mail) {
			//вторая строка из 2-х ячеек таблицы - под почту
			$return .= '<tr><td colspan="2">';
			$my_user = get_user_by('id', $author_id);
			$out_email = $my_user->user_email;
			$return .= '<a href="mailto:'.$out_email.'">'.$out_email.'</a>';
			$return .= '</td></tr>';
		}
		// ----- вывод почты ------------------
	}
		
	$return = rtrim( $return, ', ' );
	// удаление последней запятой из вывода, если она есть
	
	//закрытие таблицы тэгами
    $return .= '</table>';

	if ( $args['echo'] ) {
		echo $return;
	} else {
		return $return;
	}
}
//---------------------------
//
?>