<?php
/**
*Plugin Name: TSL plugin seo text
*Plugin URI:  https://wpavonis.ru/tsl-plaginy/plagin-analiza-seo-kljuchevyh-fraz-v-poste-backend.html
*Author URI:  https://wpavonis.ru/tsl-plaginy.html
*Description: SEO text analysis
*Author:      GoodWin
*Version:     1.4
*/
//
if ( ! defined( 'ABSPATH' ) ) {
	include 'index.php'; // тк внутри условия - подключится по мере выполнения
    exit;
}

//-------------------------------------------------------------------------------


function tsl_seo_meta_box() {
	$screens = array( 'post', 'page' );
	add_meta_box(
		'tsl_seo_metabox', // ID нашего метабокса
		'SEO анализ текста', // заголовок
		'tsl_seo_metabox_callback', // Вызов(callback)
		$screens, // Где будет отображаться наше поле, можно просто 'page' or 'post'
		'normal',
		'high');
}
add_action('add_meta_boxes', 'tsl_seo_meta_box'); // Запускаем функцию

function tsl_seo_metabox_callback( $post ) {
 
	// сначала получаем значения этих полей
	// заголовок
	$seo_title = get_post_meta( $post->ID, 'seo_title', true );
	//вернет строку или пустышку
	$seo_title = trim($seo_title);
	//придумать - что делать с последним переводом строки
	
	$post_full_text = get_the_content(); //содержимое
	
	$post_text_orig = strip_tags( $post_full_text ); //без тэгов и html
	$post_text = mb_strtolower($post_text_orig); //все к нижнему регистру
	
	$post_text_nonspace = str_replace(array(" "), '', $post_text);
 
	// одноразовые числа, кстати тут нет супер-большой необходимости их использовать
	wp_nonce_field( 'seopostsettingsupdate-' . $post->ID, '_truenonce' );
	
	
	//приводим массив и переменную в порядок --------------------------------------
    //$arr_text = explode("\n", $seo_title);
	$arr_text = preg_split('/\r\n|\r|\n/', $seo_title);
	//для пустой строки вернет массив из одного элемента
	//работает более корректно, чем implode - но сами символы перевода удаляет
	
	$arr_count = count( $arr_text );
	//размер массива

	/*
	echo $arr_count;
	echo '<pre>';
	print_r($arr_text);
	echo '</pre>';
	*/
	
	
	
	if ($arr_count < 5) {
		$num_row = 5;
	}else{
		$num_row = $arr_count + 1;
	}
	//число строк в поле textarea
	
	$data_number = '';
	if ( ! empty($arr_text[0]) ) { 
	// если есть что перебирать - первый элемент не пустой - иначе ошибка PHP
		foreach ($arr_text as $key => $val) {
			//$str_found = trim( mb_strtolower( str_replace(array("\r\n", "\r", "\n"), '', $val ) ) );
			$str_found = mb_strtolower( trim( $val ) );
			//trim все срежет и ищем в нижнем регистре
			$count_number = mb_substr_count($post_text, $str_found  );
			$data_number .= ( $count_number == 0 ? '<font color="red"><b>'.$count_number.'</b></font>' : '<b>'.$count_number.'</b>').'<br/>';
			//собираем цифры в текстовую переменную с переносом строк br
		}
	}
	
	$arr_word = str_word_count($post_text,1,'АаБбВвГгДдЕеЁёЖжЗзИиЙйКкЛлМмНнОоПпРрСсТтУуФфХхЦцЧчШшЩщЪъЫыЬьЭэЮюЯя');
	
	$before_unset = count($arr_word);
	for  ($i = 0; $i < $before_unset; $i++) {
		if (mb_strlen ($arr_word[$i])<= 2) {
			//echo $arr_word[$i].$i.' <br/>';
			unset($arr_word[$i]);
		}
	}
	
	//индексы крашатся, т.е. в индексах будут дырки - но нам не важно
	//главное - размер массива меньше
	
	echo 'Число слов длиной более 2х символов: '.count($arr_word).'<br/>';
	echo 'Число знаков на странице: '.mb_strlen($post_text, 'utf-8').'<br/>';
	echo 'Число знаков без пробелов: '.mb_strlen($post_text_nonspace, 'utf-8').'<br/>';
	echo '<br/>';
	

	
	
	
	/*
	echo count($arr_word);
	
	echo '<pre>';
	print_r($arr_word);
	echo '</pre>';
	*/
	
	

		
	echo '<table class="form-table" width="70%">
		<tr>
			<td width="15%" style="text-align: right;">Вхождения</td>
			<td style="text-align: left;"><label for="seo_title">SEO-ключевые фразы</label></td>
		</tr>
		<tr>
			<td width="15%" style="text-align: right; vertical-align: top; padding-top: 18px ; line-height: 1.3;">'.$data_number.'</td>
			<td><textarea style="width:70%; line-height: 1.3;" id="seo_title" name="seo_title" rows="'.$num_row.'">'. $seo_title .'</textarea></td>	
		</tr>
	</table>';
	
	echo '<b>Использование заголовков H2 - H6. Заголовок H1 должна формировать тема</b><br/>';
	
	preg_match_all('/<h[2-6].*?>(.*)<\/h[2-6]>/i', $post_full_text, $matches);
	
	/*
	echo '<pre>';
	print_r($matches);
	echo '</pre>';
	*/
	
	
	//$matches[0] - первый массив в массиве с полным вхождением, т.е. с тэгами
	//$matches[1] - второй массив - только значения - не нужен
	
	if (count( $matches[0] ) == 0) {
		echo '<font color="red"><b>Заголовки не найдены</b></font>';
	}else{
		echo '
		<style type="text/css">
		UL { 
			list-style-type: disc; 
			list-style-position: inside;
			color: navy; 
		}
		</style>';
		//без стилей в метабоксе не работает		
		echo '<ul>';
		foreach ($matches[0] as $key => $arr_out1) {
			$low_str = mb_strtolower($arr_out1); //в нижний регистр
			//ищем h2 h3 h4
			if ( mb_strpos($low_str, 'h2') >= 1 ) {
				echo '<li><b>H2 - </b>';
			}elseif (mb_strpos($low_str, 'h3') >= 1) {
				echo '<li><b> H3 - </b>';
			}elseif (mb_strpos($low_str, 'h4') >= 1) {
				echo '<li><b>  H4 - </b>';
			}elseif (mb_strpos($low_str, 'h5') >= 1) {
				echo '<li><b>   H5 - </b>';
			}elseif (mb_strpos($low_str, 'h6') >= 1) {
				echo '<li><b>    H6 - </b>';
			}
			
		echo strip_tags($arr_out1).'</li>' ; //убираем все тэги
		}
		echo '</ul>';

	}
		
	//echo $post_text;
	//echo $arr_count;
	
	/*
	echo '<p><b>Вывод цитаты (отрывка)</b></p>';
	echo '<br/>'.get_the_excerpt();
	//echo '<p>Контент</p>';
	//echo strip_tags(get_post_field('post_content', $post->ID));
	*/
}

//--------------------------------------------------------------------------

add_action( 'save_post', 'true_save_meta', 10, 2 );
 
function true_save_meta( $post_id, $post ) {
 
	// проверка одноразовых полей
	if ( ! isset( $_POST[ '_truenonce' ] ) || ! wp_verify_nonce( $_POST[ '_truenonce' ], 'seopostsettingsupdate-' . $post->ID ) ) {
		return $post_id;
	}
 
	// проверяем, может ли текущий юзер редактировать пост
	$post_type = get_post_type_object( $post->post_type );
 
	if ( ! current_user_can( $post_type->cap->edit_post, $post_id ) ) {
		return $post_id;
	}
 
	// ничего не делаем для автосохранений
	if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ) {
		return $post_id;
	}
 
	// проверяем тип записи
	if( !(('page' == $post->post_type) || ('post' == $post->post_type))  ) {
		//те это не пост и не страница
		//вроде глупо - но можно создават свои типы - товары, загрузки и прочее
		return $post_id;
	}
 
	if( isset( $_POST[ 'seo_title' ] ) ) {
		//перед сохранением причешем
		$seo_title = $_POST[ 'seo_title' ];
		
		
		//приводим массив и переменную в порядок --------------------------------------
		$arr_text = explode("\n", $seo_title);
		//для пустой строки вернет массив из одного элемента
		$arr_count = count( $arr_text );
		//размер массива
		for  ($i = 0; $i < $arr_count; $i++) {
			$arr_text[$i] = ltrim($arr_text[$i]);
			//полный трим отрежет справа переводы строки
			if (empty(trim($arr_text[$i]))){
				unset($arr_text[$i]);
				//выкидываем пустые строки
			}
		}
		$seo_title = implode("", $arr_text );
		//собираем переменную заново -----------------------------------------------------
		
		
		update_post_meta( $post_id, 'seo_title', $seo_title  );
	} else {
		delete_post_meta( $post_id, 'seo_title' );
	}

 
	return $post_id;
 
}

//
?>